unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Microsoft.DirectX, Microsoft.DirectX.Direct3D;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  private
    urzadzenie: Device;
  public
    function  InicjujGrafike: Boolean;
    procedure Rysuj;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 266);
  Self.Name := 'TWinForm';
  Self.Text := 'DirectX.NET Przykad 1';
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

function TWinForm.InicjujGrafike: Boolean;
var
  parametry: PresentParameters;
begin
  try
    parametry:= PresentParameters.Create;
    //Tryb okienkowy
    parametry.Windowed:= true;
    parametry.SwapEffect:= Microsoft.DirectX.Direct3D.SwapEffect.Discard;
    //Tworzenie urzadzenia DirectX
    urzadzenie:= Device.Create(0, DeviceType.Hardware, Self.Handle,
      CreateFlags.SoftwareVertexProcessing, [parametry]);
    Result:= true;
  except
    on DirectXException do Result:= false;
  end;
end;

procedure TWinForm.Rysuj;
begin
  if (urzadzenie=nil) then Exit;
  //Czyszczenie ekranu
  urzadzenie.Clear(ClearFlags.Target, System.Drawing.Color.White, 1, 0);
  urzadzenie.BeginScene;
  //Tutaj w przyszoci umiecimy operacje rysowania...
  urzadzenie.EndScene;
  //Wywietlenie klatki
  urzadzenie.Present;
end;

end.
